/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.ModelWrapper;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.BasePersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class BasePersistenceImpl<T extends BaseModel<T>>
implements BasePersistence<T>,
SessionFactory {
    public static final String COUNT_COLUMN_NAME = "COUNT_VALUE";
    protected static final Object[] FINDER_ARGS_EMPTY = new Object[0];
    protected static final String ORDER_BY_ASC = " ASC";
    protected static final String ORDER_BY_ASC_HAS_NEXT = " ASC, ";
    protected static final String ORDER_BY_CLAUSE = " ORDER BY ";
    protected static final String ORDER_BY_DESC = " DESC";
    protected static final String ORDER_BY_DESC_HAS_NEXT = " DESC, ";
    protected static final String WHERE_AND = " AND ";
    protected static final String WHERE_GREATER_THAN = " >= ? ";
    protected static final String WHERE_GREATER_THAN_HAS_NEXT = " >= ? AND ";
    protected static final String WHERE_LESSER_THAN = " <= ? ";
    protected static final String WHERE_LESSER_THAN_HAS_NEXT = " <= ? AND ";
    protected static final String WHERE_OR = " OR ";
    protected ModelListener<T>[] listeners = new ModelListener[0];
    private static Log _log = LogFactoryUtil.getLog(BasePersistenceImpl.class);
    private DataSource _dataSource;
    private DB _db;
    private Dialect _dialect;
    private Class<T> _modelClass;
    private SessionFactory _sessionFactory;

    @Override
    public void clearCache() {
    }

    @Override
    public void clearCache(List<T> model) {
    }

    @Override
    public void clearCache(T model) {
    }

    @Override
    public void closeSession(Session session) {
        this._sessionFactory.closeSession(session);
    }

    @Override
    public long countWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        return this.countWithDynamicQuery(dynamicQuery, ProjectionFactoryUtil.rowCount());
    }

    @Override
    public long countWithDynamicQuery(DynamicQuery dynamicQuery, Projection projection) throws SystemException {
        if (projection == null) {
            projection = ProjectionFactoryUtil.rowCount();
        }
        dynamicQuery.setProjection(projection);
        List results = this.findWithDynamicQuery(dynamicQuery);
        if (results.isEmpty()) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    @Override
    public T fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        OrderFactoryUtil.addOrderByComparator(dynamicQuery, orderByComparator);
        return this.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public void flush() throws SystemException {
        try {
            Session session = this._sessionFactory.getCurrentSession();
            if (session != null) {
                session.flush();
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public Session getCurrentSession() throws ORMException {
        return this._sessionFactory.getCurrentSession();
    }

    @Override
    public DataSource getDataSource() {
        return this._dataSource;
    }

    public DB getDB() {
        return this._db;
    }

    @Override
    public Dialect getDialect() {
        return this._dialect;
    }

    @Override
    public ModelListener<T>[] getListeners() {
        return this.listeners;
    }

    @Override
    public Class<T> getModelClass() {
        return this._modelClass;
    }

    @Override
    public Session openNewSession(Connection connection) throws ORMException {
        return this._sessionFactory.openNewSession(connection);
    }

    @Override
    public Session openSession() throws ORMException {
        return this._sessionFactory.openSession();
    }

    @Override
    public SystemException processException(Exception e) {
        if (!(e instanceof ORMException)) {
            _log.error("Caught unexpected exception " + e.getClass().getName());
        }
        if (_log.isDebugEnabled()) {
            _log.debug(e, e);
        }
        return new SystemException(e);
    }

    @Override
    public void registerListener(ModelListener<T> listener) {
        List<ModelListener<ModelListener>> listenersList = ListUtil.fromArray(this.listeners);
        listenersList.add(listener);
        this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
    }

    @Override
    public T remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(T model) throws SystemException {
        ModelListener<T> listener;
        if (model instanceof ModelWrapper) {
            ModelWrapper modelWrapper = (ModelWrapper)model;
            model = (BaseModel)modelWrapper.getWrappedModel();
        }
        ModelListener<T>[] modelListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            listener.onBeforeRemove(model);
            ++n2;
        }
        model = this.removeImpl(model);
        modelListenerArray = this.listeners;
        n = this.listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            listener.onAfterRemove(model);
            ++n2;
        }
        return model;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
        this._dialect = this._sessionFactory.getDialect();
        this._db = DBFactoryUtil.getDB(this._dialect);
    }

    @Override
    public void unregisterListener(ModelListener<T> listener) {
        List<ModelListener<ModelListener>> listenersList = ListUtil.fromArray(this.listeners);
        listenersList.remove(listener);
        this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
    }

    @Override
    public T update(T model) throws SystemException {
        ModelListener<T> listener;
        if (model instanceof ModelWrapper) {
            ModelWrapper modelWrapper = (ModelWrapper)model;
            model = (BaseModel)modelWrapper.getWrappedModel();
        }
        boolean isNew = model.isNew();
        ModelListener<T>[] modelListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            if (isNew) {
                listener.onBeforeCreate(model);
            } else {
                listener.onBeforeUpdate(model);
            }
            ++n2;
        }
        model = this.updateImpl(model);
        modelListenerArray = this.listeners;
        n = this.listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            if (isNew) {
                listener.onAfterCreate(model);
            } else {
                listener.onAfterUpdate(model);
            }
            ++n2;
        }
        return model;
    }

    @Override
    public T update(T model, boolean merge) throws SystemException {
        ModelListener<T> listener;
        if (model instanceof ModelWrapper) {
            ModelWrapper modelWrapper = (ModelWrapper)model;
            model = (BaseModel)modelWrapper.getWrappedModel();
        }
        boolean isNew = model.isNew();
        ModelListener<T>[] modelListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            if (isNew) {
                listener.onBeforeCreate(model);
            } else {
                listener.onBeforeUpdate(model);
            }
            ++n2;
        }
        model = this.updateImpl(model, merge);
        modelListenerArray = this.listeners;
        n = this.listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = modelListenerArray[n2];
            if (isNew) {
                listener.onAfterCreate(model);
            } else {
                listener.onAfterUpdate(model);
            }
            ++n2;
        }
        return model;
    }

    @Override
    public T update(T model, boolean merge, ServiceContext serviceContext) throws SystemException {
        return this.update(model, serviceContext);
    }

    @Override
    public T update(T model, ServiceContext serviceContext) throws SystemException {
        try {
            ServiceContextThreadLocal.pushServiceContext(serviceContext);
            this.update(model);
            T t = model;
            return t;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    protected static String removeConjunction(String sql) {
        int pos = sql.indexOf(WHERE_AND);
        if (pos != -1) {
            sql = sql.substring(0, pos);
        }
        return sql;
    }

    protected void appendOrderByComparator(StringBundler query, String entityAlias, OrderByComparator orderByComparator) {
        this.appendOrderByComparator(query, entityAlias, orderByComparator, false);
    }

    protected void appendOrderByComparator(StringBundler query, String entityAlias, OrderByComparator orderByComparator, boolean sqlQuery) {
        query.append(ORDER_BY_CLAUSE);
        String[] orderByFields = orderByComparator.getOrderByFields();
        int i = 0;
        while (i < orderByFields.length) {
            Set<String> badColumnNames;
            query.append(entityAlias);
            query.append(orderByFields[i]);
            if (sqlQuery && (badColumnNames = this.getBadColumnNames()).contains(orderByFields[i])) {
                query.append("_");
            }
            if (i + 1 < orderByFields.length) {
                if (orderByComparator.isAscending(orderByFields[i])) {
                    query.append(ORDER_BY_ASC_HAS_NEXT);
                } else {
                    query.append(ORDER_BY_DESC_HAS_NEXT);
                }
            } else if (orderByComparator.isAscending(orderByFields[i])) {
                query.append(ORDER_BY_ASC);
            } else {
                query.append(ORDER_BY_DESC);
            }
            ++i;
        }
    }

    protected Set<String> getBadColumnNames() {
        return Collections.emptySet();
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }

    protected T removeImpl(T model) throws SystemException {
        throw new UnsupportedOperationException();
    }

    protected void setModelClass(Class<T> modelClass) {
        this._modelClass = modelClass;
    }

    protected T updateImpl(T model) throws SystemException {
        throw new UnsupportedOperationException();
    }

    protected T updateImpl(T model, boolean merge) throws SystemException {
        return this.updateImpl(model);
    }
}

