/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.dekker.Match;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PhraseMatchDetector {
    public List<List<Match>> detect(Map<Token, VariantGraph.Vertex> linkedTokens, VariantGraph base, Iterable<Token> tokens) {
        ArrayList<List<Match>> phraseMatches = new ArrayList<List<Match>>();
        ArrayList<VariantGraph.Vertex> basePhrase = new ArrayList<VariantGraph.Vertex>();
        ArrayList<Token> witnessPhrase = new ArrayList<Token>();
        VariantGraph.Vertex previous = base.getStart();
        for (Token token : tokens) {
            boolean isNear;
            if (!linkedTokens.containsKey(token)) {
                this.addNewPhraseMatchAndClearBuffer(phraseMatches, basePhrase, witnessPhrase);
                continue;
            }
            VariantGraph.Vertex baseVertex = linkedTokens.get(token);
            boolean sameTranspositions = new HashSet<Set<VariantGraph.Vertex>>(previous.transpositions()).equals(new HashSet<Set<VariantGraph.Vertex>>(baseVertex.transpositions()));
            boolean sameWitnesses = previous.witnesses().equals(baseVertex.witnesses());
            boolean directedEdge = previous.outgoing().containsKey(baseVertex);
            boolean bl = isNear = sameTranspositions && sameWitnesses && directedEdge && (previous.outgoing().size() == 1 || baseVertex.incoming().size() == 1);
            if (!isNear) {
                this.addNewPhraseMatchAndClearBuffer(phraseMatches, basePhrase, witnessPhrase);
            }
            basePhrase.add(baseVertex);
            witnessPhrase.add(token);
            previous = baseVertex;
        }
        if (!basePhrase.isEmpty()) {
            phraseMatches.add(Match.createPhraseMatch(basePhrase, witnessPhrase));
        }
        return phraseMatches;
    }

    private void addNewPhraseMatchAndClearBuffer(List<List<Match>> phraseMatches, List<VariantGraph.Vertex> basePhrase, List<Token> witnessPhrase) {
        if (!basePhrase.isEmpty()) {
            phraseMatches.add(Match.createPhraseMatch(basePhrase, witnessPhrase));
            basePhrase.clear();
            witnessPhrase.clear();
        }
    }
}

