/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.astar;

import eu.interedition.collatex.dekker.astar.Cost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public abstract class AstarAlgorithm<N, C extends Cost<C>> {
    protected Map<N, N> cameFrom;

    protected List<N> aStar(N startNode, C startCost) {
        HashSet closed = new HashSet();
        this.cameFrom = new HashMap<N, N>();
        HashMap<Object, C> gScore = new HashMap<Object, C>();
        gScore.put(startNode, startCost);
        final HashMap<Object, C> fScore = new HashMap<Object, C>();
        fScore.put(startNode, ((Cost)gScore.get(startNode)).plus(this.heuristicCostEstimate(startNode)));
        Comparator comp = new Comparator<N>(){

            @Override
            public int compare(N node0, N node1) {
                return ((Cost)fScore.get(node0)).compareTo(fScore.get(node1));
            }
        };
        PriorityQueue<Object> open = new PriorityQueue<Object>(10, comp);
        open.add(startNode);
        while (!open.isEmpty()) {
            Object current = open.poll();
            if (this.isGoal(current)) {
                return this.reconstructPath(this.cameFrom, current);
            }
            closed.add(current);
            for (Object neighbor : this.neighborNodes(current)) {
                if (closed.contains(neighbor)) continue;
                C tentativeGScore = ((Cost)gScore.get(current)).plus(this.distBetween(current, neighbor));
                if (open.contains(neighbor) && tentativeGScore.compareTo(gScore.get(neighbor)) >= 0) continue;
                this.cameFrom.put(neighbor, current);
                gScore.put(neighbor, tentativeGScore);
                fScore.put(neighbor, ((Cost)gScore.get(neighbor)).plus(this.heuristicCostEstimate(neighbor)));
                if (open.contains(neighbor)) continue;
                open.add(neighbor);
            }
        }
        throw new IllegalStateException("No node found that suits goal condition!");
    }

    protected List<N> reconstructPath(Map<N, N> cameFrom, N current) {
        ArrayList<N> path = new ArrayList<N>();
        do {
            path.add(0, current);
        } while ((current = cameFrom.get(current)) != null);
        return path;
    }

    protected abstract boolean isGoal(N var1);

    protected abstract Iterable<N> neighborNodes(N var1);

    protected abstract C heuristicCostEstimate(N var1);

    protected abstract C distBetween(N var1, N var2);
}

