/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.dekker.token_index;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.Witness;
import eu.interedition.collatex.dekker.Match;
import eu.interedition.collatex.dekker.island.Coordinate;
import eu.interedition.collatex.dekker.island.Island;
import eu.interedition.collatex.dekker.token_index.Block;
import eu.interedition.collatex.dekker.token_index.TokenIndex;
import eu.interedition.collatex.util.VariantGraphRanking;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TokenIndexToMatches {
    public static Set<Island> createMatches(TokenIndex tokenIndex, VariantGraph.Vertex[] vertex_array, VariantGraph g, Iterable<Token> w) {
        VariantGraphRanking ranking = VariantGraphRanking.of(g);
        HashSet<Island> result = new HashSet<Island>();
        Witness witness = w.iterator().next().getWitness();
        int startTokenPositionForWitness = tokenIndex.getStartTokenPositionForWitness(witness);
        List<Block.Instance> instances = tokenIndex.getBlockInstancesForWitness(witness);
        for (Block.Instance witnessInstance : instances) {
            Block block = witnessInstance.block;
            List<Block.Instance> allInstances = block.getAllInstances();
            List graphInstances = allInstances.stream().filter(instance -> instance.start_token < startTokenPositionForWitness).collect(Collectors.toList());
            for (Block.Instance graphInstance : graphInstances) {
                Island island = new Island(witnessInstance);
                int graph_start_token = graphInstance.start_token;
                for (int i = 0; i < block.length; ++i) {
                    VariantGraph.Vertex v = vertex_array[graph_start_token + i];
                    if (v == null) {
                        throw new RuntimeException("Vertex is null for token \"+graph_start_token+i+\" that is supposed to be mapped to a vertex in the graph!");
                    }
                    int column = ranking.apply(v) - 1;
                    int witnessStartToken = witnessInstance.start_token + i;
                    int row = witnessStartToken - startTokenPositionForWitness;
                    Token token = tokenIndex.token_array[witnessStartToken];
                    Match match = new Match(v, token);
                    Coordinate coordinate = new Coordinate(row, column, match);
                    island.add(coordinate);
                }
                result.add(island);
            }
        }
        return result;
    }
}

