/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.matching;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Matches {
    public final Map<Token, List<VariantGraph.Vertex>> allMatches;
    public final Set<Token> unmatchedInWitness;
    public final Set<Token> ambiguousInWitness;
    public final Set<Token> uniqueInWitness;

    public static Matches between(Iterable<VariantGraph.Vertex> vertices, Iterable<Token> witnessTokens, Comparator<Token> comparator) {
        HashMap<Token, List<VariantGraph.Vertex>> allMatches = new HashMap<Token, List<VariantGraph.Vertex>>();
        StreamSupport.stream(vertices.spliterator(), false).forEach(vertex -> vertex.tokens().stream().findFirst().ifPresent(baseToken -> StreamSupport.stream(witnessTokens.spliterator(), false).filter(witnessToken -> comparator.compare((Token)baseToken, (Token)witnessToken) == 0).forEach(matchingToken -> allMatches.computeIfAbsent((Token)matchingToken, t -> new ArrayList()).add(vertex))));
        Set unmatchedInWitness = StreamSupport.stream(witnessTokens.spliterator(), false).filter(t -> !allMatches.containsKey(t)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set ambiguousInBase = allMatches.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), v -> 1, (a, b) -> a + b)).entrySet().stream().filter(v -> (Integer)v.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        Set ambiguousInWitness = Stream.concat(StreamSupport.stream(witnessTokens.spliterator(), false).filter(t -> allMatches.getOrDefault(t, Collections.emptyList()).size() > 1), allMatches.entrySet().stream().filter(match -> ((List)match.getValue()).stream().anyMatch(ambiguousInBase::contains)).map(Map.Entry::getKey)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set uniqueInWitness = StreamSupport.stream(witnessTokens.spliterator(), false).filter(t -> allMatches.getOrDefault(t, Collections.emptyList()).size() == 1 && !ambiguousInWitness.contains(t)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new Matches(allMatches, unmatchedInWitness, ambiguousInWitness, uniqueInWitness);
    }

    private Matches(Map<Token, List<VariantGraph.Vertex>> allMatches, Set<Token> unmatchedInWitness, Set<Token> ambiguousInWitness, Set<Token> uniqueInWitness) {
        this.allMatches = Collections.unmodifiableMap(allMatches);
        this.unmatchedInWitness = Collections.unmodifiableSet(unmatchedInWitness);
        this.ambiguousInWitness = Collections.unmodifiableSet(ambiguousInWitness);
        this.uniqueInWitness = Collections.unmodifiableSet(uniqueInWitness);
    }
}

