/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixarray;

import eu.interedition.collatex.suffixarray.BPR;
import eu.interedition.collatex.suffixarray.DeepShallow;
import eu.interedition.collatex.suffixarray.DensePositiveDecorator;
import eu.interedition.collatex.suffixarray.DivSufSort;
import eu.interedition.collatex.suffixarray.ExtraTrailingCellsDecorator;
import eu.interedition.collatex.suffixarray.ISuffixArrayBuilder;
import eu.interedition.collatex.suffixarray.QSufSort;
import eu.interedition.collatex.suffixarray.SAIS;
import eu.interedition.collatex.suffixarray.Skew;

public enum Algorithm {
    SKEW("K\u00e4rkk\u00e4inen-Sanders"),
    SKEW_D("K\u00e4rkk\u00e4inen-Sanders (decorated for arbitrary input symbols)"),
    DIVSUFSORT("Mori's algorithm"),
    SAIS("SA-IS algorithm"),
    BPR("Klaus-Bernd Sch\u00fcrmann's bpr algorithm"),
    DEEP_SHALLOW("Manzini-Ferragina"),
    QSUFSORT("Larrson-Sadakane qsufsort algorithm");

    private final String name;

    private Algorithm(String name) {
        this.name = name;
    }

    public ISuffixArrayBuilder getDecoratedInstance() {
        switch (this) {
            case SKEW: {
                return new DensePositiveDecorator(new ExtraTrailingCellsDecorator(this.getInstance(), 575));
            }
        }
        return this.getInstance();
    }

    public ISuffixArrayBuilder getInstance() {
        switch (this) {
            case SKEW: {
                return new Skew();
            }
            case DIVSUFSORT: {
                return new DivSufSort();
            }
            case SAIS: {
                return new SAIS();
            }
            case QSUFSORT: {
                return new QSufSort();
            }
            case BPR: {
                return new BPR();
            }
            case DEEP_SHALLOW: {
                return new DeepShallow();
            }
        }
        throw new RuntimeException("No algorithm for constant: " + (Object)((Object)this));
    }

    public ISuffixArrayBuilder getMemoryConservingInstance() {
        switch (this) {
            case QSUFSORT: {
                return new QSufSort(false);
            }
            case BPR: {
                return new BPR(false);
            }
            case DEEP_SHALLOW: {
                return new DeepShallow(false);
            }
        }
        return this.getInstance();
    }

    public String getName() {
        return this.name;
    }
}

