/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.Edge;
import eu.interedition.collatex.suffixtree.Node;
import eu.interedition.collatex.suffixtree.SequenceTerminal;
import eu.interedition.collatex.suffixtree.SuffixTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class Cursor<T, S extends Iterable<T>> {
    private final SuffixTree<T, S> tree;
    private Node<T, S> node;
    private Edge<T, S> edge;
    private int length;

    Cursor(SuffixTree<T, S> tree) {
        this.tree = tree;
        this.node = tree.getRoot();
        this.edge = null;
        this.length = 0;
    }

    boolean proceedTo(T item) {
        if (this.edge == null) {
            Edge<T, S> tmpEdge = this.node.getEdgeStarting(item);
            if (tmpEdge != null) {
                this.edge = tmpEdge;
                this.length = 1;
                return true;
            }
            return false;
        }
        if (this.edge.getLength() > this.length) {
            T nextItem = this.edge.getItemAt(this.length);
            if (nextItem != null && item.equals(nextItem)) {
                ++this.length;
                return true;
            }
            return false;
        }
        Node<T, S> terminal = this.edge.getTerminal();
        if (terminal == null) {
            return false;
        }
        Edge<T, S> tmpEdge = terminal.getEdgeStarting(item);
        if (tmpEdge != null) {
            this.edge = tmpEdge;
            this.length = 1;
            this.node = terminal;
            return true;
        }
        return false;
    }

    Collection<SequenceTerminal<S>> getSequenceTerminals() {
        if (this.edge == null) {
            return this.node.getSuffixTerminals();
        }
        if (this.edge.getLength() - 1 == this.length && !this.edge.isTerminating() || this.edge.getItemAt(this.length).getClass().equals(SequenceTerminal.class) && !this.edge.isTerminating()) {
            T seqTerminal = this.edge.getItemAt(this.length);
            SequenceTerminal term = (SequenceTerminal)seqTerminal;
            HashSet<SequenceTerminal<S>> collection = new HashSet<SequenceTerminal<S>>();
            collection.add(term);
            return collection;
        }
        Node<T, S> terminal = this.edge.getTerminal();
        if (terminal == null) {
            return Collections.emptySet();
        }
        Collection<Edge<T, S>> edges = terminal.getEdges();
        HashSet<SequenceTerminal<S>> returnCollection = new HashSet<SequenceTerminal<S>>();
        for (Edge<T, S> edge : edges) {
            T o = edge.getStartItem();
            if (!o.getClass().equals(SequenceTerminal.class)) continue;
            SequenceTerminal returnTerminal = (SequenceTerminal)o;
            returnCollection.add(returnTerminal);
        }
        return returnCollection;
    }

    void returnToRoot() {
        this.node = this.tree.getRoot();
        this.edge = null;
        this.length = 0;
    }
}

