/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.suffixtree;

import eu.interedition.collatex.suffixtree.Sequence;

class Suffix<T, S extends Iterable<T>> {
    private int start;
    private int end;
    private Sequence<T, S> sequence;

    public Suffix(int start, int end, Sequence<T, S> sequence) {
        this.testStartAndEndValues(start, end);
        this.testStartEndAgainstSequenceLength(start, end, sequence.getLength());
        this.start = start;
        this.end = end;
        this.sequence = sequence;
    }

    private void testStartEndAgainstSequenceLength(int start, int end, int sequenceLength) {
        if (start > sequenceLength || end > sequenceLength) {
            throw new IllegalArgumentException("Suffix start and end must be less than or equal to sequence length");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[(");
        sb.append(this.start).append(", ").append(this.end).append(")");
        int end = this.getEndPosition();
        for (int i = this.start; i < end; ++i) {
            sb.append(this.sequence.getItem(i)).append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    int getEndPosition() {
        return this.end;
    }

    Object getEndItem() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sequence.getItem(this.end - 1);
    }

    Object getStart() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sequence.getItem(this.start);
    }

    void decrement() {
        if (this.start == this.end) {
            this.increment();
        }
        ++this.start;
    }

    void increment() {
        ++this.end;
        if (this.end > this.sequence.getLength()) {
            throw new IndexOutOfBoundsException("Incremented suffix beyond end of sequence");
        }
    }

    boolean isEmpty() {
        return this.start >= this.end || this.end > this.sequence.getLength();
    }

    int getRemaining() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.end - this.start;
    }

    public Object getItemXFromEnd(int distanceFromEnd) {
        if (this.end - distanceFromEnd < this.start) {
            throw new IllegalArgumentException(distanceFromEnd + " extends before the start of this suffix: ");
        }
        return this.sequence.getItem(this.end - distanceFromEnd);
    }

    void reset(int start, int end) {
        this.testStartAndEndValues(start, end);
        this.start = start;
        this.end = end;
    }

    private void testStartAndEndValues(int start, int end) {
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("You cannot set a suffix start or end to less than zero.");
        }
        if (end < start) {
            throw new IllegalArgumentException("A suffix end position cannot be less than its start position.");
        }
    }
}

