/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.util;

import eu.interedition.collatex.Token;
import eu.interedition.collatex.VariantGraph;
import java.util.BitSet;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class VertexMatch
implements Comparable<VertexMatch> {
    public final VariantGraph.Vertex vertex;
    public final int vertexRank;

    VertexMatch(VariantGraph.Vertex vertex, int vertexRank) {
        this.vertex = vertex;
        this.vertexRank = vertexRank;
    }

    @Override
    public int compareTo(VertexMatch o) {
        return this.vertexRank - o.vertexRank;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VertexMatch) {
            return this.vertexRank == ((VertexMatch)obj).vertexRank;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.vertexRank;
    }

    public static <T extends VertexMatch> Comparator<SortedSet<T>> setComparator() {
        return (o1, o2) -> ((VertexMatch)o1.first()).compareTo((VertexMatch)o2.first());
    }

    public static Function<WithTokenIndex, WithToken> tokenResolver(Token[] tokens) {
        return input -> new WithToken(input.vertex, input.vertexRank, tokens[input.token]);
    }

    public static Predicate<SortedSet<WithTokenIndex>> filter(BitSet rankFilter, BitSet tokenFilter) {
        return input -> input.stream().anyMatch(match -> tokenFilter.get(match.token) || rankFilter.get(match.vertexRank));
    }

    public static class WithTokenIndex
    extends VertexMatch {
        public final int token;

        public WithTokenIndex(VariantGraph.Vertex vertex, int vertexRank, int token) {
            super(vertex, vertexRank);
            this.token = token;
        }

        public String toString() {
            return "{" + this.vertex + " -> " + this.token + "}";
        }
    }

    public static class WithToken
    extends VertexMatch {
        public final Token token;

        public WithToken(VariantGraph.Vertex vertex, int vertexRank, Token token) {
            super(vertex, vertexRank);
            this.token = token;
        }

        public String toString() {
            return "{" + this.vertex + " -> " + this.token + "}";
        }
    }
}

