/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Crypto;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ARRAY_SORT = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASIN = 75;
    private static final int FUNC_ATAN = 76;
    private static final int FUNC_ATAN2 = 77;
    private static final int FUNC_BITAND = 78;
    private static final int FUNC_BITOR = 79;
    private static final int FUNC_BITXOR = 80;
    private static final int FUNC_CHAR = 81;
    private static final int FUNC_CONCAT = 82;
    private static final int FUNC_COS = 83;
    private static final int FUNC_COT = 84;
    private static final int FUNC_CRYPT_KEY = 85;
    private static final int FUNC_DATABASE = 86;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 87;
    private static final int FUNC_DATABASE_NAME = 88;
    private static final int FUNC_DATABASE_TIMEZONE = 89;
    private static final int FUNC_DATABASE_VERSION = 90;
    private static final int FUNC_DATEADD = 91;
    private static final int FUNC_DATEDIFF = 92;
    private static final int FUNC_DEGREES = 93;
    private static final int FUNC_DIFFERENCE = 94;
    private static final int FUNC_HEXTORAW = 95;
    private static final int FUNC_IDENTITY = 96;
    private static final int FUNC_ISAUTOCOMMIT = 97;
    private static final int FUNC_ISOLATION_LEVEL = 98;
    private static final int FUNC_ISREADONLYDATABASE = 99;
    private static final int FUNC_ISREADONLYDATABASEFILES = 100;
    private static final int FUNC_ISREADONLYSESSION = 101;
    private static final int FUNC_LEFT = 102;
    private static final int FUNC_LOAD_FILE = 103;
    private static final int FUNC_LOB_ID = 104;
    private static final int FUNC_LOCATE = 105;
    private static final int FUNC_LOG10 = 106;
    private static final int FUNC_LPAD = 107;
    private static final int FUNC_LTRIM = 108;
    private static final int FUNC_PI = 109;
    private static final int FUNC_RADIANS = 110;
    private static final int FUNC_RAND = 111;
    private static final int FUNC_RAWTOHEX = 112;
    private static final int FUNC_REGEXP_MATCHES = 113;
    private static final int FUNC_REPEAT = 114;
    private static final int FUNC_REPLACE = 115;
    private static final int FUNC_REVERSE = 116;
    private static final int FUNC_RIGHT = 117;
    private static final int FUNC_ROUND = 118;
    private static final int FUNC_ROUNDMAGIC = 119;
    private static final int FUNC_RPAD = 120;
    private static final int FUNC_RTRIM = 121;
    private static final int FUNC_SECONDS_MIDNIGHT = 122;
    private static final int FUNC_SEQUENCE_ARRAY = 123;
    private static final int FUNC_SESSION_ID = 124;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 125;
    private static final int FUNC_SESSION_TIMEZONE = 126;
    private static final int FUNC_SIGN = 127;
    private static final int FUNC_SIN = 128;
    private static final int FUNC_SOUNDEX = 129;
    private static final int FUNC_SPACE = 130;
    private static final int FUNC_SUBSTR = 131;
    private static final int FUNC_SYSDATE = 132;
    private static final int FUNC_TAN = 133;
    private static final int FUNC_TIMESTAMP = 134;
    private static final int FUNC_TIMESTAMPADD = 135;
    private static final int FUNC_TIMESTAMPDIFF = 136;
    private static final int FUNC_TIMEZONE = 137;
    private static final int FUNC_TO_CHAR = 138;
    private static final int FUNC_TO_DATE = 139;
    private static final int FUNC_TO_TIMESTAMP = 140;
    private static final int FUNC_TRANSACTION_CONTROL = 141;
    private static final int FUNC_TRANSACTION_ID = 142;
    private static final int FUNC_TRANSACTION_SIZE = 143;
    private static final int FUNC_TRUNC = 144;
    private static final int FUNC_TRUNCATE = 145;
    private static final int FUNC_UUID = 146;
    private static final int FUNC_UNIX_TIMESTAMP = 147;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private String matchPattern;
    private Pattern pattern;

    public static FunctionSQL newCustomFunction(String token, int tokenType) {
        int id = customRegularFuncMap.get(tokenType, -1);
        if (id == -1) {
            id = customValueFuncMap.get(tokenType, -1);
        }
        if (id == -1) {
            return null;
        }
        switch (tokenType) {
            case 431: 
            case 639: 
            case 677: 
            case 682: 
            case 693: 
            case 716: 
            case 724: 
            case 730: {
                return new FunctionSQL(id);
            }
            case 692: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 647: 
            case 648: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = emptyParamList;
                return function;
            }
            case 715: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                return function;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 31) {
            switch (tokenType) {
                case 685: {
                    function.extractSpec = 151;
                    break;
                }
                case 704: {
                    function.extractSpec = 286;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 659: {
                    function.extractSpec = 655;
                    break;
                }
                case 688: {
                    function.extractSpec = 687;
                    break;
                }
                case 660: {
                    function.extractSpec = 656;
                    break;
                }
                case 661: {
                    function.extractSpec = 657;
                    break;
                }
                case 662: {
                    function.extractSpec = 658;
                    break;
                }
                case 733: {
                    function.extractSpec = 734;
                    break;
                }
                default: {
                    function.extractSpec = tokenType;
                }
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    public static boolean isRegularFunction(int tokenType) {
        return customRegularFuncMap.get(tokenType, -1) != -1;
    }

    public static boolean isValueFunction(int tokenType) {
        return customValueFuncMap.get(tokenType, -1) != -1;
    }

    private FunctionCustom(int id) {
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 72: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 124: 
            case 125: 
            case 126: 
            case 137: 
            case 141: 
            case 142: 
            case 143: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 84: 
            case 93: 
            case 95: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 116: 
            case 119: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 133: {
                this.parseList = singleParamList;
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 85: 
            case 94: 
            case 102: 
            case 113: 
            case 114: 
            case 117: 
            case 138: 
            case 139: 
            case 140: {
                this.parseList = doubleParamList;
                break;
            }
            case 91: 
            case 92: 
            case 115: 
            case 123: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 107: 
            case 120: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 146: 
            case 147: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 96: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 135: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 136: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 103: 
            case 118: 
            case 134: 
            case 144: 
            case 145: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 111: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 1: {
                Expression[] newNodes = new Expression[4];
                newNodes[0] = nodes[0];
                newNodes[1] = nodes[1];
                newNodes[3] = nodes[2];
                nodes = newNodes;
                break;
            }
            case 32: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 31: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 82: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, data);
            }
            case 86: {
                return session.getDatabase().getPath();
            }
            case 88: {
                return session.getDatabase().getUniqueName();
            }
            case 97: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 101: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 99: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 100: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 98: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 125: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 87: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 141: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 137: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 126: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 89: {
                int sec = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(sec, 0);
            }
            case 90: {
                return "2.1.0";
            }
            case 124: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 142: {
                return session.transactionTimestamp;
            }
            case 143: {
                return (long)session.actionIndex;
            }
            case 104: {
                LobData lob = (LobData)data[0];
                if (lob == null) {
                    return null;
                }
                return lob.getId();
            }
            case 96: {
                Number id = session.getLastIdentity();
                if (id instanceof Long) {
                    return id;
                }
                return ValuePool.getLong(id.longValue());
            }
            case 123: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                HsqlArrayList list = new HsqlArrayList();
                Object current = data[0];
                Type type = this.nodes[0].getDataType();
                boolean ascending = type.compare(session, data[1], data[0]) >= 0;
                while (true) {
                    int compare = type.compare(session, current, data[1]);
                    if (ascending ? compare > 0 : compare < 0) break;
                    list.add(current);
                    Object newValue = type.add(current, data[2], this.nodes[2].getDataType());
                    compare = type.compare(session, current, newValue);
                    if (ascending ? compare >= 0 : compare <= 0) break;
                    current = newValue;
                }
                Object[] array = list.toArray();
                return array;
            }
            case 135: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                int part = ((Number)this.nodes[0].valueData).intValue();
                long units = ((Number)data[1]).longValue();
                TimestampData source = (TimestampData)data[2];
                switch (part) {
                    case 831: {
                        long seconds = units / 1000000000L;
                        int nanos = (int)(units % 1000000000L);
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 832: {
                        long seconds = units / 1000L;
                        int nanos = (int)(units % 1000L) * 1000000;
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 833: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 834: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 835: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 836: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 837: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 838: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 839: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 840: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 12L, t);
                        return this.dataType.add(source, o, t);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 136: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                TimestampData a = (TimestampData)data[2];
                TimestampData b = (TimestampData)data[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    a = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, a, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    b = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, b, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (part) {
                    case 831: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000000000L * interval.getSeconds() + (long)interval.getNanos());
                    }
                    case 832: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000L * interval.getSeconds() + (long)(interval.getNanos() / 1000000));
                    }
                    case 833: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 834: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 835: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 836: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 837: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 7L);
                    }
                    case 838: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 839: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 3L);
                    }
                    case 840: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 118: 
            case 144: {
                int interval = 103;
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType type = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (data[1] == null) {
                            return null;
                        }
                        interval = HsqlDateTime.toStandardIntervalPart((String)data[1]);
                    }
                    if (interval < 0) {
                        throw Error.error(5566, (String)data[1]);
                    }
                    return this.funcType == 118 ? type.round(data[0], interval) : type.truncate(data[0], interval);
                }
            }
            case 145: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                    offset = ((Number)data[1]).intValue();
                }
                return this.funcType == 118 ? ((NumberType)this.dataType).round(data[0], offset) : ((NumberType)this.dataType).truncate(data[0], offset);
            }
            case 138: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                return HsqlDateTime.toFormattedDate(date, (String)data[1], format);
            }
            case 139: 
            case 140: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = HsqlDateTime.toDate((String)data[0], (String)data[1], format);
                long millis = date.getTime();
                int nanos = 0;
                if (this.funcType == 139) {
                    millis = HsqlDateTime.convertToNormalisedDate(millis, format.getCalendar());
                } else {
                    nanos = (int)(millis % 1000L) * 100000;
                }
                return new TimestampData(millis / 1000L, nanos);
            }
            case 134: {
                boolean unary;
                boolean bl = unary = this.nodes[1] == null;
                if (data[0] == null) {
                    return null;
                }
                if (unary) {
                    return Type.SQL_TIMESTAMP.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                TimeData time = (TimeData)Type.SQL_TIME.convertToType(session, data[1], this.nodes[1].dataType);
                return new TimestampData(date.getSeconds() + (long)time.getSeconds(), time.getNanos());
            }
            case 109: {
                return new Double(Math.PI);
            }
            case 111: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                long seed = ((Number)data[0]).longValue();
                return new Double(session.random(seed));
            }
            case 146: {
                if (this.nodes[0] == null) {
                    UUID uuid = UUID.randomUUID();
                    long hi = uuid.getMostSignificantBits();
                    long lo = uuid.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
                }
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType()) {
                    return new BinaryData(StringConverter.toBinaryUUID((String)data[0]), false);
                }
                return StringConverter.toStringUUID(((BinaryData)data[0]).getBytes());
            }
            case 147: {
                if (this.nodes[0] == null) {
                    TimestampData ts = session.getCurrentTimestamp(false);
                    return ts.getSeconds();
                }
                if (data[0] == null) {
                    return null;
                }
                return ((TimestampData)data[0]).getSeconds();
            }
            case 71: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.acos(d));
            }
            case 75: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.asin(d));
            }
            case 76: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.atan(d));
            }
            case 83: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.cos(d));
            }
            case 84: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                double c = 1.0 / Math.tan(d);
                return new Double(c);
            }
            case 93: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toDegrees(d));
            }
            case 128: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.sin(d));
            }
            case 133: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.tan(d));
            }
            case 106: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.log10(d));
            }
            case 110: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toRadians(d));
            }
            case 127: {
                if (data[0] == null) {
                    return null;
                }
                int val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return ValuePool.getInt(val);
            }
            case 77: {
                if (data[0] == null) {
                    return null;
                }
                double a = NumberType.toDouble(data[0]);
                double b = NumberType.toDouble(data[1]);
                return new Double(Math.atan2(a, b));
            }
            case 74: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(arg.charAt(0));
            }
            case 81: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int arg = ((Number)data[0]).intValue();
                if (Character.isValidCodePoint(arg) && Character.isValidCodePoint((char)arg)) {
                    return String.valueOf((char)arg);
                }
                throw Error.error(3472);
            }
            case 119: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    offset = ((Number)data[1]).intValue();
                }
                return ((NumberType)this.dataType).round(data[0], offset);
            }
            case 129: {
                if (data[0] == null) {
                    return null;
                }
                String s = (String)data[0];
                return new String(FunctionCustom.soundex(s), 0, 4);
            }
            case 78: 
            case 79: 
            case 80: {
                byte[] v;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (this.nodes[0].dataType.isIntegralType()) {
                    data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                    data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                    long v2 = 0L;
                    long a = ((Number)data[0]).longValue();
                    long b = ((Number)data[1]).longValue();
                    switch (this.funcType) {
                        case 78: {
                            v2 = a & b;
                            break;
                        }
                        case 79: {
                            v2 = a | b;
                            break;
                        }
                        case 80: {
                            v2 = a ^ b;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(v2);
                        }
                        case 25: {
                            return ValuePool.getLong(v2);
                        }
                        case 4: {
                            return ValuePool.getInt((int)v2);
                        }
                        case 5: {
                            return ValuePool.getInt((int)v2 & 0xFFFF);
                        }
                        case -6: {
                            return ValuePool.getInt((int)v2 & 0xFF);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] a = ((BinaryData)data[0]).getBytes();
                byte[] b = ((BinaryData)data[1]).getBytes();
                switch (this.funcType) {
                    case 78: {
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 79: {
                        v = BitMap.or(a, b);
                        break;
                    }
                    case 80: {
                        v = BitMap.xor(a, b);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(v, this.dataType.precision);
            }
            case 94: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                char[] s1 = FunctionCustom.soundex((String)data[0]);
                char[] s2 = FunctionCustom.soundex((String)data[1]);
                int e = 0;
                if (s1[0] == s2[0]) {
                    ++e;
                }
                if (e == 4) {
                    return ValuePool.getInt(e);
                }
                int js = 1;
                for (int i = 1; i < 4; ++i) {
                    for (int j = js; j < 4; ++j) {
                        if (s1[j] != s2[i]) continue;
                        ++e;
                        ++i;
                        ++js;
                    }
                }
                e = 0;
                return ValuePool.getInt(e);
            }
            case 95: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 112: {
                if (data[0] == null) {
                    return null;
                }
                BlobData binary = (BlobData)data[0];
                byte[] bytes = binary.getBytes(session, 0L, (int)binary.length(session));
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 114: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                String string = (String)data[0];
                int i = ((Number)data[1]).intValue();
                StringBuffer sb = new StringBuffer(string.length() * i);
                while (i-- > 0) {
                    sb.append(string);
                }
                return sb.toString();
            }
            case 115: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                String string = (String)data[0];
                String find = (String)data[1];
                String replace = (String)data[2];
                StringBuffer sb = new StringBuffer();
                int start = 0;
                while (true) {
                    int i;
                    if ((i = string.indexOf(find, start)) == -1) break;
                    sb.append(string.substring(start, i));
                    sb.append(replace);
                    start = i + find.length();
                }
                sb.append(string.substring(start));
                return sb.toString();
            }
            case 102: 
            case 117: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                int count = ((Number)data[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, data[0], 0L, count, true, this.funcType == 117);
            }
            case 130: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int count = ((Number)data[0]).intValue();
                char[] array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 116: {
                if (data[0] == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 113: {
                Matcher matcher;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (!data[1].equals(this.matchPattern)) {
                    this.matchPattern = (String)data[1];
                    this.pattern = Pattern.compile(this.matchPattern);
                }
                return (matcher = this.pattern.matcher((String)data[0])).matches() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 85: {
                byte[] bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 103: {
                String fileName = (String)data[0];
                if (fileName == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(fileName, (String)data[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(fileName);
            }
            case 107: 
            case 120: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                String value = this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isLobType() ? (String)data[0] : this.nodes[0].dataType.convertToString(data[0]);
                int length = (Integer)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType);
                String pad = " ";
                if (this.nodes[2] != null && (pad = this.nodes[2].dataType.convertToString(data[2])).length() == 0) {
                    pad = " ";
                }
                value = (String)Type.SQL_VARCHAR.trim(session, value, 32, true, true);
                value = StringUtil.toPaddedString(value, length, pad, this.funcType == 120);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, value, Type.SQL_VARCHAR);
                }
                return value;
            }
            case 73: {
                if (data[0] == null) {
                    return null;
                }
                ArrayType dt = (ArrayType)this.dataType;
                SortAndSlice exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                Object array = ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, parent);
                return;
            }
            case 86: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 88: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 87: 
            case 90: 
            case 98: 
            case 125: 
            case 141: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 89: 
            case 126: 
            case 137: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 96: 
            case 104: 
            case 124: 
            case 142: 
            case 143: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), 0x100000);
                return;
            }
            case 91: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                int part = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 135;
            }
            case 135: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 92: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                int part = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 136;
            }
            case 136: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block43 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode != 91) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 836: 
                            case 837: 
                            case 838: 
                            case 839: 
                            case 840: {
                                break block43;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode == 93 || this.nodes[2].dataType.typeCode == 95) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 118: 
            case 144: {
                boolean single;
                boolean bl = single = this.nodes.length == 1 || this.nodes[1] == null;
                if (this.nodes[0].dataType == null) {
                    if (single) {
                        this.nodes[0].dataType = Type.SQL_DECIMAL;
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (!single && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 145: {
                Number offset = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    offset = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        offset = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (offset != null) {
                    int scale = offset;
                    if (scale < 0) {
                        scale = 0;
                    } else if (scale > this.dataType.scale) {
                        scale = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && scale != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)scale, scale);
                    }
                }
                return;
            }
            case 138: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 40L);
                return;
            }
            case 139: 
            case 140: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = this.funcType == 139 ? Type.SQL_DATE : Type.SQL_TIMESTAMP;
                return;
            }
            case 134: {
                Type argType = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (argType == null) {
                        argType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!argType.isCharacterType() && argType.typeCode != 93 && argType.typeCode != 95) {
                        throw Error.error(5561);
                    }
                } else {
                    if (argType == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            argType = this.nodes[1].dataType;
                        } else {
                            argType = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (argType.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (argType.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(argType.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || argType.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 109: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 146: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 147: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 111: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 93: 
            case 106: 
            case 110: 
            case 119: 
            case 128: 
            case 133: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 127: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 77: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 129: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType != null) continue;
                    this.nodes[i].dataType = Type.SQL_INTEGER;
                }
                this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 81: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 95: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 112: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 114: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(isChar = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = isChar ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 115: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 102: 
            case 117: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 130: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 113: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 85: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 107: 
            case 120: {
                Number value;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (value = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(value.longValue());
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer sb = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 107: 
            case 120: {
                StringBuffer sb = new StringBuffer(this.name);
                sb.append("(").append(this.nodes[0].getSQL());
                sb.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(",").append(this.nodes[2].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 72: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 124: 
            case 125: 
            case 126: 
            case 137: 
            case 141: 
            case 142: 
            case 143: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 135: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 136: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 111: 
            case 147: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    sb.append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 103: 
            case 118: 
            case 144: 
            case 145: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes[0] != null) {
                    sb.append(',').append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 84: 
            case 93: 
            case 95: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 116: 
            case 119: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 133: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 94: 
            case 102: 
            case 113: 
            case 114: 
            case 117: 
            case 134: 
            case 138: 
            case 139: 
            case 140: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 115: 
            case 123: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
        }
        return super.getSQL();
    }

    public static char[] soundex(String s) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return b;
    }

    int getTSIToken(String string) {
        int part;
        if ("yy".equalsIgnoreCase(string)) {
            part = 840;
        } else if ("mm".equalsIgnoreCase(string)) {
            part = 838;
        } else if ("dd".equalsIgnoreCase(string)) {
            part = 836;
        } else if ("hh".equalsIgnoreCase(string)) {
            part = 835;
        } else if ("mi".equalsIgnoreCase(string)) {
            part = 834;
        } else if ("ss".equalsIgnoreCase(string)) {
            part = 833;
        } else if ("ms".equalsIgnoreCase(string)) {
            part = 832;
        } else {
            throw Error.error(5566, string);
        }
        return part;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(85);
        nonDeterministicFuncSet.add(86);
        nonDeterministicFuncSet.add(87);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(96);
        nonDeterministicFuncSet.add(97);
        nonDeterministicFuncSet.add(101);
        nonDeterministicFuncSet.add(99);
        nonDeterministicFuncSet.add(100);
        nonDeterministicFuncSet.add(98);
        nonDeterministicFuncSet.add(124);
        nonDeterministicFuncSet.add(125);
        nonDeterministicFuncSet.add(126);
        nonDeterministicFuncSet.add(134);
        nonDeterministicFuncSet.add(137);
        nonDeterministicFuncSet.add(141);
        nonDeterministicFuncSet.add(142);
        nonDeterministicFuncSet.add(143);
        nonDeterministicFuncSet.add(146);
        nonDeterministicFuncSet.add(147);
        customRegularFuncMap.put(630, 71);
        customRegularFuncMap.put(631, 72);
        customRegularFuncMap.put(632, 73);
        customRegularFuncMap.put(633, 74);
        customRegularFuncMap.put(634, 75);
        customRegularFuncMap.put(635, 76);
        customRegularFuncMap.put(636, 77);
        customRegularFuncMap.put(638, 78);
        customRegularFuncMap.put(639, 6);
        customRegularFuncMap.put(640, 79);
        customRegularFuncMap.put(641, 80);
        customRegularFuncMap.put(33, 81);
        customRegularFuncMap.put(642, 81);
        customRegularFuncMap.put(643, 82);
        customRegularFuncMap.put(644, 83);
        customRegularFuncMap.put(645, 84);
        customRegularFuncMap.put(646, 85);
        customRegularFuncMap.put(647, 43);
        customRegularFuncMap.put(648, 51);
        customRegularFuncMap.put(580, 86);
        customRegularFuncMap.put(650, 88);
        customRegularFuncMap.put(649, 87);
        customRegularFuncMap.put(651, 89);
        customRegularFuncMap.put(652, 90);
        customRegularFuncMap.put(653, 91);
        customRegularFuncMap.put(654, 92);
        customRegularFuncMap.put(73, 5);
        customRegularFuncMap.put(659, 5);
        customRegularFuncMap.put(660, 5);
        customRegularFuncMap.put(661, 5);
        customRegularFuncMap.put(662, 5);
        customRegularFuncMap.put(664, 93);
        customRegularFuncMap.put(665, 94);
        customRegularFuncMap.put(667, 95);
        customRegularFuncMap.put(127, 5);
        customRegularFuncMap.put(128, 96);
        customRegularFuncMap.put(135, 32);
        customRegularFuncMap.put(671, 97);
        customRegularFuncMap.put(672, 99);
        customRegularFuncMap.put(673, 100);
        customRegularFuncMap.put(674, 101);
        customRegularFuncMap.put(675, 98);
        customRegularFuncMap.put(677, 26);
        customRegularFuncMap.put(153, 102);
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(679, 103);
        customRegularFuncMap.put(686, 104);
        customRegularFuncMap.put(680, 1);
        customRegularFuncMap.put(682, 14);
        customRegularFuncMap.put(683, 106);
        customRegularFuncMap.put(684, 107);
        customRegularFuncMap.put(685, 31);
        customRegularFuncMap.put(169, 5);
        customRegularFuncMap.put(173, 5);
        customRegularFuncMap.put(688, 5);
        customRegularFuncMap.put(693, 8);
        customRegularFuncMap.put(694, 109);
        customRegularFuncMap.put(695, 5);
        customRegularFuncMap.put(696, 110);
        customRegularFuncMap.put(697, 111);
        customRegularFuncMap.put(698, 112);
        customRegularFuncMap.put(699, 113);
        customRegularFuncMap.put(234, 114);
        customRegularFuncMap.put(700, 115);
        customRegularFuncMap.put(701, 116);
        customRegularFuncMap.put(240, 117);
        customRegularFuncMap.put(702, 118);
        customRegularFuncMap.put(703, 119);
        customRegularFuncMap.put(705, 120);
        customRegularFuncMap.put(704, 31);
        customRegularFuncMap.put(250, 5);
        customRegularFuncMap.put(706, 5);
        customRegularFuncMap.put(707, 123);
        customRegularFuncMap.put(708, 124);
        customRegularFuncMap.put(709, 125);
        customRegularFuncMap.put(710, 126);
        customRegularFuncMap.put(711, 127);
        customRegularFuncMap.put(712, 128);
        customRegularFuncMap.put(713, 129);
        customRegularFuncMap.put(514, 130);
        customRegularFuncMap.put(715, 23);
        customRegularFuncMap.put(717, 133);
        customRegularFuncMap.put(282, 134);
        customRegularFuncMap.put(718, 135);
        customRegularFuncMap.put(719, 136);
        customRegularFuncMap.put(720, 137);
        customRegularFuncMap.put(721, 138);
        customRegularFuncMap.put(722, 139);
        customRegularFuncMap.put(723, 140);
        customRegularFuncMap.put(726, 141);
        customRegularFuncMap.put(727, 142);
        customRegularFuncMap.put(728, 143);
        customRegularFuncMap.put(729, 144);
        customRegularFuncMap.put(295, 145);
        customRegularFuncMap.put(730, 27);
        customRegularFuncMap.put(731, 147);
        customRegularFuncMap.put(732, 146);
        customRegularFuncMap.put(733, 5);
        customRegularFuncMap.put(323, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(716, 52);
        customValueFuncMap.put(724, 43);
        customValueFuncMap.put(692, 52);
    }
}

