/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;

public class JDBCSavepoint
implements Savepoint {
    int id;
    String name;
    JDBCConnection connection;

    JDBCSavepoint(String name, JDBCConnection conn) throws SQLException {
        if (name == null) {
            throw Util.nullArgument("name");
        }
        if (conn == null) {
            throw Util.nullArgument("conn");
        }
        this.name = name;
        this.connection = conn;
    }

    JDBCSavepoint(JDBCConnection conn) throws SQLException {
        if (conn == null) {
            throw Util.nullArgument("conn");
        }
        this.id = conn.getSavepointID();
        this.connection = conn;
    }

    public int getSavepointId() throws SQLException {
        if (this.name == null) {
            return this.id;
        }
        throw Util.notSupported();
    }

    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw Util.notSupported();
        }
        return this.name;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

