/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected boolean allQuoted;
    private String encoding;

    public RowOutputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        this.initTextDatabaseRowOutput(fieldSep, varSep, longvarSep, allQuoted, encoding);
    }

    private void initTextDatabaseRowOutput(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.allQuoted = allQuoted;
        this.encoding = encoding;
    }

    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextCache.NL);
    }

    public void writeSize(int size) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    public void writeType(int type) {
    }

    public void writeString(String s) {
        if ((s = this.checkConvertString(s, this.fieldSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String s) {
        if ((s = this.checkConvertString(s, this.varSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String s) {
        if ((s = this.checkConvertString(s, this.longvarSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String s, String sep) {
        if (s.indexOf(10) != -1 || s.indexOf(13) != -1) {
            throw new IllegalArgumentException(Error.getMessage(485));
        }
        if (s.indexOf(sep) != -1) {
            return null;
        }
        return s;
    }

    private byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        return bytes;
    }

    protected void writeByteArray(byte[] b) {
        this.ensureRoom(b.length * 2);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, b);
        this.count += b.length * 2;
    }

    public void writeShort(int i) {
        this.writeInt(i);
    }

    public void writeInt(int i) {
        this.writeBytes(Integer.toString(i));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeIntData(int i, int position) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    public void writeLong(long i) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    protected void writeFieldType(Type type) {
        this.writeBytes(this.nextSep);
        switch (type.typeCode) {
            case 12: 
            case 100: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    protected void writeNull(Type type) {
        this.writeFieldType(type);
    }

    protected void writeChar(String s, Type t) {
        switch (t.typeCode) {
            case 1: {
                this.writeString(s);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(s);
                return;
            }
        }
        this.writeLongVarString(s);
    }

    protected void writeSmallint(Number o) {
        this.writeString(o.toString());
    }

    protected void writeInteger(Number o) {
        this.writeString(o.toString());
    }

    protected void writeBigint(Number o) {
        this.writeString(o.toString());
    }

    protected void writeReal(Double o) {
        this.writeString(o.toString());
    }

    protected void writeDecimal(BigDecimal o, Type type) {
        this.writeString(type.convertToString(o));
    }

    protected void writeBoolean(Boolean o) {
        this.writeString(o.toString());
    }

    protected void writeDate(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    protected void writeTime(TimeData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeString(type.convertToString(o));
    }

    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeBytes(type.convertToString(o));
    }

    protected void writeOther(JavaObjectData o) {
        byte[] ba = o.getBytes();
        this.writeByteArray(ba);
    }

    protected void writeBit(BinaryData o) {
        String s = StringConverter.byteArrayToBitString(o.getBytes(), (int)o.bitLength(null));
        this.writeString(s);
    }

    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    protected void writeClob(ClobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    protected void writeBlob(BlobData o, Type type) {
        this.writeString(Long.toString(o.getId()));
    }

    protected void writeArray(Object[] o, Type type) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception e) {
            this.reset();
        }
        int rowsize = this.size();
        this.reset();
        return rowsize;
    }

    public int getStorageSize(int size) {
        return size;
    }

    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }
}

