/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class QueryConfig
implements Serializable {
    public static final String LOCALE = "locale";
    public static final String SEARCH_SUBFOLDERS = "search.subfolders";
    private static final String _HITS_PROCESSING_ENABLED = "hitsProcessingEnabled";
    private static final boolean _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.collated.spell.check.result.enabled"), true);
    private static final int _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_SCORES_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.collated.spell.check.result.scores.threshold"), 50);
    private static final boolean _INDEX_SEARCH_HIGHLIGHT_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.highlight.enabled"));
    private static final int _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.fragment.size"));
    private static final int _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.snippet.size"));
    private static final boolean _INDEX_SEARCH_QUERY_INDEXING_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.query.indexing.enabled"), true);
    private static final int _INDEX_SEARCH_QUERY_INDEXING_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.query.indexing.threshold"), 50);
    private static final boolean _INDEX_SEARCH_QUERY_SUGGESTION_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.query.suggestion.enabled"), true);
    private static final int _INDEX_SEARCH_QUERY_SUGGESTION_MAX = GetterUtil.getInteger(PropsUtil.get("index.search.query.suggestion.max"), 5);
    private static final int _INDEX_SEARCH_QUERY_SUGGESTION_SCORES_THRESHOLD = GetterUtil.getInteger(PropsUtil.get("index.search.query.suggestion.scores.threshold"), 50);
    private static final boolean _INDEX_SEARCH_SCORING_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.scoring.enabled"));
    private Map<String, Serializable> _attributes = new HashMap<String, Serializable>();

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public int getCollatedSpellCheckResultScoresThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.collated.spell.check.result.scores.threshold"), _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_SCORES_THRESHOLD);
    }

    public int getHighlightFragmentSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.fragment.size"), _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE);
    }

    public int getHighlightSnippetSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.snippet.size"), _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this._attributes.get(LOCALE);
        if (locale == null) {
            locale = LocaleUtil.getMostRelevantLocale();
        }
        return locale;
    }

    public int getQueryIndexingThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.indexing.threshold"), _INDEX_SEARCH_QUERY_INDEXING_THRESHOLD);
    }

    public int getQuerySuggestionMax() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.suggestion.max"), _INDEX_SEARCH_QUERY_SUGGESTION_MAX);
    }

    public int getQuerySuggestionScoresThreshold() {
        return GetterUtil.getInteger(this._attributes.get("index.search.query.suggestion.scores.threshold"), _INDEX_SEARCH_QUERY_SUGGESTION_SCORES_THRESHOLD);
    }

    public boolean isCollatedSpellCheckResultEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.collated.spell.check.result.enabled"), _INDEX_SEARCH_COLLATED_SPELL_CHECK_RESULT_ENABLED);
    }

    public boolean isHighlightEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.highlight.enabled"), false);
    }

    public boolean isHitsProcessingEnabled() {
        return GetterUtil.getBoolean(this._attributes.get(_HITS_PROCESSING_ENABLED), true);
    }

    public boolean isQueryIndexingEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.query.indexing.enabled"), _INDEX_SEARCH_QUERY_INDEXING_ENABLED);
    }

    public boolean isQuerySuggestionEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.query.suggestion.enabled"), _INDEX_SEARCH_QUERY_SUGGESTION_ENABLED);
    }

    public boolean isScoreEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.scoring.enabled"), _INDEX_SEARCH_SCORING_ENABLED);
    }

    public boolean isSearchSubfolders() {
        return GetterUtil.getBoolean(this._attributes.get(SEARCH_SUBFOLDERS));
    }

    public Serializable removeAttribute(String name) {
        return this._attributes.remove(name);
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setCollatedSpellCheckResultEnabled(boolean collatedSpellCheckResultEnabled) {
        this._attributes.put("index.search.collated.spell.check.result.enabled", Boolean.valueOf(collatedSpellCheckResultEnabled));
    }

    public void setCollatedSpellCheckResultScoresThreshold(int collatedSpellCheckResultScoresThreshold) {
        this._attributes.put("index.search.collated.spell.check.result.scores.threshold", Integer.valueOf(collatedSpellCheckResultScoresThreshold));
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        if (_INDEX_SEARCH_HIGHLIGHT_ENABLED) {
            this._attributes.put("index.search.highlight.enabled", Boolean.valueOf(highlightEnabled));
        } else {
            this._attributes.put("index.search.highlight.enabled", Boolean.valueOf(false));
        }
    }

    public void setHighlightFragmentSize(int highlightFragmentSize) {
        this._attributes.put("index.search.highlight.fragment.size", Integer.valueOf(highlightFragmentSize));
    }

    public void setHighlightSnippetSize(int highlightSnippetSize) {
        this._attributes.put("index.search.highlight.snippet.size", Integer.valueOf(highlightSnippetSize));
    }

    public void setHitsProcessingEnabled(boolean hitsProcessingEnabled) {
        this._attributes.put(_HITS_PROCESSING_ENABLED, Boolean.valueOf(hitsProcessingEnabled));
    }

    public void setLocale(Locale locale) {
        this._attributes.put(LOCALE, locale);
    }

    public void setQueryIndexingEnabled(boolean enabled) {
        this._attributes.put("index.search.query.indexing.enabled", Boolean.valueOf(enabled));
    }

    public void setQueryIndexingThreshold(int queryIndexingThreshold) {
        this._attributes.put("index.search.query.indexing.threshold", Integer.valueOf(queryIndexingThreshold));
    }

    public void setQuerySuggestionEnabled(boolean querySuggestionEnabled) {
        this._attributes.put("index.search.query.suggestion.enabled", Boolean.valueOf(querySuggestionEnabled));
    }

    public void setQuerySuggestionScoresThreshold(int querySuggestionScoresThreshold) {
        this._attributes.put("index.search.query.suggestion.scores.threshold", Integer.valueOf(querySuggestionScoresThreshold));
    }

    public void setQuerySuggestionsMax(int querySuggestionMax) {
        this._attributes.put("index.search.query.suggestion.max", Integer.valueOf(querySuggestionMax));
    }

    public void setScoreEnabled(boolean scoreEnabled) {
        this._attributes.put("index.search.scoring.enabled", Boolean.valueOf(scoreEnabled));
    }

    public void setSearchSubfolders(boolean searchSubfolders) {
        this._attributes.put(SEARCH_SUBFOLDERS, Boolean.valueOf(searchSubfolders));
    }
}

