/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class PortletSetupUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletSetupUtil.class);

    public static JSONObject cssToJSONObject(PortletPreferences portletSetup, String css) throws Exception {
        return PortletSetupUtil._toJSONObject(portletSetup, css);
    }

    public static String cssToJSONString(PortletPreferences portletSetup) {
        String css = portletSetup.getValue("portletSetupCss", "");
        try {
            JSONObject jsonObject = PortletSetupUtil._toJSONObject(portletSetup, css);
            return jsonObject.toString();
        }
        catch (Exception e) {
            css = null;
            if (_log.isWarnEnabled()) {
                _log.warn(e);
            }
            return css;
        }
    }

    private static JSONObject _toJSONObject(PortletPreferences portletSetup, String css) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Transform CSS to JSON " + css);
        }
        JSONObject cssJSONObject = null;
        if (Validator.isNotNull(css)) {
            cssJSONObject = JSONFactoryUtil.createJSONObject(css);
            cssJSONObject.put("hasCssValue", true);
        } else {
            cssJSONObject = JSONFactoryUtil.createJSONObject();
        }
        JSONObject portletDataJSONObject = JSONFactoryUtil.createJSONObject();
        cssJSONObject.put("portletData", portletDataJSONObject);
        JSONObject titlesJSONObject = JSONFactoryUtil.createJSONObject();
        portletDataJSONObject.put("titles", titlesJSONObject);
        Locale[] locales = LanguageUtil.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            String languageId = LocaleUtil.toLanguageId(locales[i]);
            String title = portletSetup.getValue("portletSetupTitle_" + languageId, null);
            if (Validator.isNotNull(languageId)) {
                titlesJSONObject.put(languageId, title);
            }
            ++i;
        }
        boolean useCustomTitle = GetterUtil.getBoolean(portletSetup.getValue("portletSetupUseCustomTitle", null));
        String showBorders = GetterUtil.getString(portletSetup.getValue("portletSetupShowBorders", null));
        String linkToLayoutUuid = GetterUtil.getString(portletSetup.getValue("portletSetupLinkToLayoutUuid", null));
        portletDataJSONObject.put("useCustomTitle", useCustomTitle);
        portletDataJSONObject.put("showBorders", showBorders);
        portletDataJSONObject.put("portletLinksTarget", linkToLayoutUuid);
        return cssJSONObject;
    }
}

